#include "c4d_memory.h"
#include "c4d_basecontainer.h"
#include "c4d_file.h"
#include "c4d_baselist.h"

void* BaseContainer::operator new(size_t,int line,const CHAR *file)
{
	return C4DOS.Bc->Alloc(NOTOK);
}

void BaseContainer::operator delete(void* del)
{
	C4DOS.Bc->Free((BaseContainer*)del);
}

BaseContainer::BaseContainer(void)
{
	C4DOS.Bc->Init(this,NOTOK);
}

BaseContainer::BaseContainer(LONG id)
{
	C4DOS.Bc->Init(this,id);
}

BaseContainer::BaseContainer(const BaseContainer &src)
{
	C4DOS.Bc->Init(this,NOTOK);
	C4DOS.Bc->CopyTo(&src,this,NULL);
} 

BaseContainer::~BaseContainer(void)
{
	C4DOS.Bc->FlushAll(this);
}

const BaseContainer& BaseContainer::operator = (const BaseContainer& n)
{
	C4DOS.Bc->CopyTo(&n,this,NULL); 
	return *this;
}

void BaseContainer::CopyTo(BaseContainer *dst,AliasTrans *trans) const
{
	C4DOS.Bc->CopyTo(this,dst,trans); 
}

BaseContainer *BaseContainer::GetClone(AliasTrans *trans) const
{
	BaseContainer *cc=C4DOS.Bc->Alloc(NOTOK);
	if (!cc) return NULL;
	C4DOS.Bc->CopyTo(this,cc,trans); 
	return cc;
}

Bool BaseContainer::operator == (const BaseContainer &c) const
{
	return C4DOS.Bc->Compare(this,&c);
}

Bool BaseContainer::operator != (const BaseContainer &c) const
{
	return !C4DOS.Bc->Compare(this,&c);
}

void BaseContainer::FlushAll(void)
{
	C4DOS.Bc->FlushAll(this);
} 

LONG BaseContainer::GetId(void) const
{
	return C4DOS.Bc->GetId(this);
}

void BaseContainer::SetId(LONG c_id)
{
	C4DOS.Bc->SetId(this,c_id);
}  

Bool BaseContainer::RemoveData(LONG id)
{
	return C4DOS.Bc->RemoveData(this,id);
}

Bool BaseContainer::RemoveIndex(LONG i)
{
	return C4DOS.Bc->RemoveIndex(this,i);
}

LONG BaseContainer::FindIndex(LONG id) const
{
	return C4DOS.Bc->FindIndex(this,id);
}

LONG BaseContainer::GetIndexId(LONG index) const
{
	return C4DOS.Bc->GetIndexId(this,index);
}

GeDataType BaseContainer::GetType(LONG id) const
{
	LONG ind=C4DOS.Bc->FindIndex(this,id);
	if (ind==NOTOK) return DA_NIL;
	return (GeDataType)C4DOS.Bc->GetIndexType(this,ind);
}

GeDataType BaseContainer::GetIndexType(LONG index) const
{
	return (GeDataType)C4DOS.Bc->GetIndexType(this,index);
}

Bool BaseContainer::GetBool(LONG id, Bool preset) const
{
	if (FindIndex(id)==NOTOK) return preset;
	return C4DOS.Bc->GetBool(this,id);
}

LONG BaseContainer::GetLong(LONG id, LONG preset) const
{
	if (FindIndex(id)==NOTOK) return preset;
	return C4DOS.Bc->GetLong(this,id);
}

Real BaseContainer::GetReal(LONG id, Real preset) const
{
	if (FindIndex(id)==NOTOK) return preset;
	return C4DOS.Bc->GetReal(this,id);
}

Vector BaseContainer::GetVector(LONG id, const Vector &preset) const
{																							 
	if (FindIndex(id)==NOTOK) return preset;
	return C4DOS.Bc->GetVector(this,id);
}

Matrix BaseContainer::GetMatrix(LONG id, const Matrix &preset) const
{
	if (FindIndex(id)==NOTOK) return preset;
	return C4DOS.Bc->GetMatrix(this,id);
}

String BaseContainer::GetString(LONG id, const String &preset) const
{
	if (FindIndex(id)==NOTOK) return preset;
	String *str=C4DOS.Bc->GetString(this,id),s;
	if (str) s=*str;
	FreeString(str);
	return s;
}

Filename BaseContainer::GetFilename(LONG id, const Filename &preset) const
{
	if (FindIndex(id)==NOTOK) return preset;
	Filename *fn=C4DOS.Bc->GetFilename(this,id),f;
	if (fn) f=*fn;
	FreeFilename(fn);
	return f;
}

BaseContainer BaseContainer::GetContainer(LONG id) const
{
	if (FindIndex(id)==NOTOK) return BaseContainer();
	return *C4DOS.Bc->GetContainer(this,id);
}

BaseContainer *BaseContainer::GetContainerInstance(LONG id) const
{
	if (FindIndex(id)==NOTOK) return NULL;
	return C4DOS.Bc->GetContainer(this,id);
}

BaseTime BaseContainer::GetTime(LONG id, const BaseTime &preset) const
{
	if (FindIndex(id)==NOTOK) return preset;
	return C4DOS.Bc->GetBaseTime(this,id);
}

void BaseContainer::SetBool(LONG id, Bool b)
{
	C4DOS.Bc->SetBool(this,id,b);
}

void BaseContainer::SetLong(LONG id, LONG l)
{
	C4DOS.Bc->SetLong(this,id,l);
}

void BaseContainer::SetReal(LONG id, Real r)
{
	C4DOS.Bc->SetReal(this,id,r);
}

void BaseContainer::SetVector(LONG id, const Vector &v)
{
	C4DOS.Bc->SetVector(this,id,v);
}

void BaseContainer::SetMatrix(LONG id, const Matrix &v)
{
	C4DOS.Bc->SetMatrix(this,id,v);
}

void BaseContainer::SetString(LONG id, const String &s)
{
	C4DOS.Bc->SetString(this,id,&s);
}

void BaseContainer::SetFilename(LONG id, const Filename &s)
{
	C4DOS.Bc->SetFilename(this,id,&s);
}

void BaseContainer::SetContainer(LONG id, const BaseContainer &s)
{
	C4DOS.Bc->SetContainer(this,id,&s);
}

void BaseContainer::SetTime(LONG id, const BaseTime &t)
{
	C4DOS.Bc->SetBaseTime(this,id,t);
}

GeData *BaseContainer::GetIndexData(LONG index) const
{
	return C4DOS.Bc->GetIndexData(this,index);
}

Bool BaseContainer::InsData(LONG id, const GeData &n)
{
	return C4DOS.Bc->InsData(this,id,&n);
}

Bool BaseContainer::SetData(LONG id, const GeData &n)
{
	return C4DOS.Bc->SetData(this,id,&n);
}

const GeData &BaseContainer::GetData(LONG id) const
{
	return C4DOS.Bc->GetData(this,id);
}

BaseLink *BaseContainer::GetBaseLink (LONG id) const
{
	const GeData &dat = GetData(id);
	return dat.GetBaseLink();
}

BaseList2D *BaseContainer::GetLink(LONG id, BaseDocument *doc, LONG instanceof) const
{
	return C4DOS.Bc->GetLink(this,id,doc,instanceof);
}

void BaseContainer::SetLink(LONG id, BaseList2D *link)
{
	C4DOS.Bc->SetLink(this,id,link);
}

BaseObject *BaseContainer::GetObjectLink(LONG id, BaseDocument *doc) const
{
	return (BaseObject*)C4DOS.Bc->GetLink(this,id,doc,Obase);
}

BaseMaterial *BaseContainer::GetMaterialLink(LONG id, BaseDocument *doc) const
{
	return (BaseMaterial*)C4DOS.Bc->GetLink(this,id,doc,Mbase);
}

const CustomDataType*	BaseContainer::GetCustomDataType(LONG id,LONG datatype) const
{
	const GeData &dat = GetData(id);
	return dat.GetCustomDataType(datatype);
}

void BaseContainer::MergeContainer(const BaseContainer &src)
{
	C4DOS.Bc->MergeContainer(this,src);	
}

Bool BaseContainer::GetParameter(const DescID &id, GeData &t_data)
{
	return C4DOS.Bc->GetParameter(this,id,t_data);
}

Bool BaseContainer::SetParameter(const DescID &id, const GeData &t_data)
{
	return C4DOS.Bc->SetParameter(this,id,t_data);
}

